% file for iteration algorithm, optimzation problem P1
function [gamma_hat,beta_hat,N_hat,G_hat,L_hat,H_hat,L1_hat,Q_hat] = Optimization_P1(A,B,F,D,C,Mc,Nc,K0,gamma,P) 

[n,m] = size(B);
[~,q] = size(F);
[~,l] = size(D);
[p,~] = size(C);


Cx = eye(n);
Ce = eye(n+2*q);

% augmented system
A_bar = [A F zeros(n,q); zeros(q,n) zeros(q,q) eye(q); zeros(q,n) zeros(q,q) zeros(q,q)];
B_bar = [B;zeros(q,m);zeros(q,m)];
C_bar = [C zeros(p,q) zeros(p,q)];
D_bar = [D zeros(n,q); zeros(q,l) zeros(q,q); zeros(q,l) eye(q)];

D_tilde = [D zeros(n,q)];
Be_tilde = [zeros(n,n) F zeros(n,q)];
Mc_bar = [Mc; zeros(2*q,n)];


Q = sdpvar(n+2*q,n+2*q);
Y = sdpvar(n+2*q,p);
X = sdpvar(n+2*q,p);
beta1 = sdpvar(1,1);
beta2 = sdpvar(1,1);
beta3 = sdpvar(1,1);
beta4 = sdpvar(1,1);
beta5 = sdpvar(1,1);

LMI1 = blkvar();
LMI1(1,1) = beta1*(A+B*K0)*P + beta1*((A+B*K0)*P)';
LMI1(1,2) = beta1*D_tilde;
LMI1(1,3) = beta1*Mc;
LMI1(1,4) = beta1*P*Nc';
LMI1(1,5) = beta1*P*Cx';

LMI1(1,6) = Be_tilde;
LMI1(1,7) = P*Nc';
LMI1(1,8) = zeros(n,n);
LMI1(1,9) = zeros(n,n+2*q);
LMI1(1,10) = -B*K0*P;
LMI1(1,11) = zeros(n,n);

LMI1(2,2) = -beta2*gamma*eye(l+q);
LMI1(2,3) = beta2*zeros(l+q,n);
LMI1(2,4) = beta2*zeros(l+q,n);
LMI1(2,5) = beta2*zeros(l+q,n);

LMI1(2,6) = ((Q-X*C_bar)*D_bar)';
LMI1(2,7) = zeros(l+q,n);
LMI1(2,8) = zeros(l+q,n);
LMI1(2,9) = zeros(l+q,n+2*q);
LMI1(2,10) = zeros(l+q,n);
LMI1(2,11) = zeros(l+q,n);

LMI1(3,3) = -beta3*eye(n);
LMI1(3,4) = beta3*zeros(n,n);
LMI1(3,5) = beta3*zeros(n,n);

LMI1(3,6) = zeros(n,n+2*q);
LMI1(3,7) = zeros(n,n);
LMI1(3,8) = zeros(n,n);
LMI1(3,9) = zeros(n,n+2*q);
LMI1(3,10) = zeros(n,n);
LMI1(3,11) = zeros(n,n);

LMI1(4,4) = -beta4*eye(n);
LMI1(4,5) = beta4*zeros(n,n);

LMI1(4,6) = zeros(n,n+2*q);
LMI1(4,7) = zeros(n,n);
LMI1(4,8) = zeros(n,n);
LMI1(4,9) = zeros(n,n+2*q);
LMI1(4,10) = zeros(n,n);
LMI1(4,11) = zeros(n,n);

LMI1(5,5) = -beta5*gamma*eye(n);

LMI1(5,6) = zeros(n,n+2*q);
LMI1(5,7) = zeros(n,n);
LMI1(5,8) = zeros(n,n);
LMI1(5,9) = zeros(n,n+2*q);
LMI1(5,10) = zeros(n,n);
LMI1(5,11) = eye(n);

LMI1(6,6) = ((Q-X*C_bar)*A_bar-Y*C_bar)+((Q-X*C_bar)*A_bar-Y*C_bar)';
LMI1(6,7) = zeros(n+2*q,n);
LMI1(6,8) = (Q-X*C_bar)*Mc_bar;
LMI1(6,9) = Ce';
LMI1(6,10) = zeros(n+2*q,n);
LMI1(6,11) = zeros(n+2*q,n);

LMI1(7,7) = -eye(n);
LMI1(7,8) = zeros(n,n);
LMI1(7,9) = zeros(n,n+2*q);
LMI1(7,10) = zeros(n,n);
LMI1(7,11) = zeros(n,n);

LMI1(8,8) =-eye(n);
LMI1(8,9) = zeros(n,n+2*q);
LMI1(8,10) = zeros(n,n);
LMI1(8,11) = zeros(n,n);

LMI1(9,9) = -gamma*eye(n+2*q);
LMI1(9,10) = zeros(n+2*q,n);
LMI1(9,11) = zeros(n+2*q,n);

LMI1(10,10) = -P;
LMI1(10,11) = zeros(n,n);

LMI1(11,11) = -P;

LMI1 = sdpvar(LMI1);

Beta = blkvar();
Beta(1,1) = beta1;
Beta(2,2) = beta2;
Beta(3,3) = beta3;
Beta(4,4) = beta4;
Beta(5,5) = beta5;
Beta = sdpvar(Beta);

obj = trace(Beta);
const = [];

const = [const, Beta >= eps*eye(5)];
const = [const, Q >= eps*eye(n+2*q)];
const = [const, LMI1 <= -eps*eye(10*n+5*q+l)];


ops = sdpsettings('solver','mosek','verbose',0);
optimize(const,obj,ops);

L1_hat = inv(value(Q))*value(Y);
H_hat = inv(value(Q))*value(X);

Xi = eye(n+2*q) - H_hat*C_bar;
G_hat = Xi*B_bar;
N_hat = Xi*A_bar-L1_hat*C_bar;
L2 = N_hat*H_hat;
L_hat = L1_hat+L2;

gamma_hat = value(gamma);
beta_hat = value(Beta);
Q_hat = value(Q);


